﻿/*	VERSION:	1.0
	1.0

	DESCRIPTION:
		A simple tween system for times when Flash's native tween class is not available.
		Returns a promise instead of an interval;

	quikTween2( startAt, endAt, seconds, easeFunc )
	.then( animDone_func );

	USAGE:
		#include "functions/quikTween2.as"
		anim = quikTween2( 0, 300, 1, easeOut );
		anim.onProgress = function( value ){
			my_mc._x = value;
		}
		anim.then( done );
		
		// interrupting a tween during animation
		anim = quikTween2( 0, 300, 1, easeOut );
		anim.abort();
		
	EASING:
		easeLinear
		easeIn
		easeOut
		
	NOTE:
		This can also use Flash's native easing functions
*/
#include "functions/VOW.as"
function quikTween2( startAt, endAt, seconds, ease, fps ){
	var vow = VOW.make();
	
	var fps = fps || 30;
	var frames = seconds * fps;
	var mag = endAt - startAt;
	var hasBeenAborted = false;
	
	vow.promise.abort = function(){
		hasBeenAborted = true;
		vow.keep();
	}// abort()
	
	var frame = 0;
	var interval = setInterval( function(){
		if(hasBeenAborted)		return;
		frame++;
		var value = ease( frame, startAt, mag, frames );
		vow.promise.onProgress( value );
		if(frame == frames){
			clearInterval( interval );
			vow.keep( value );
		}
	}, 33 );
	
	return vow.promise;
}// quikTween()

function easeLinear( thisFrame, startAt, mag, totalFrames ){
	return mag * (thisFrame / totalFrames) + startAt;
}// easeLinear()

function easeIn( thisFrame, startAt, mag, totalFrames ){
	var pow = 3;
	var value = (thisFrame / totalFrames);
	var value = Math.pow(value, pow);
	var output = mag * value + startAt;
	return output;
}// easeIn()

function easeOut( thisFrame, startAt, mag, totalFrames ){
	var pow = 3;
	var value = (thisFrame / totalFrames);
	var value = 1 - Math.pow(1 - value, pow);
	var output = mag * value + startAt;
	return output;
}// easeOut()